<?PHP
#
#   FILE:  Hide.php (UrlChecker plugin)
#
#   Part of the Metavus digital collections platform
#   Copyright 2011-2020 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#

use Metavus\MetadataSchema;
use Metavus\Plugins\UrlChecker\Record;
use ScoutLib\StdLib;

PageTitle("Hiding a URL in the URL Checker...");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$MyPlugin = $GLOBALS["G_PluginManager"]->getPluginForCurrentPage();

$Id = StdLib::getFormValue("Id");
$UrlInfo = $MyPlugin->decodeUrlIdentifier($Id);
$ResourceId = $UrlInfo["RecordId"];
$FieldId = $UrlInfo["FieldId"];

if (Record::itemExists($ResourceId) &&
    MetadataSchema::fieldExistsInAnySchema($FieldId)) {
    $MyPlugin->hideUrl($Id);
}

$GLOBALS["AF"]->setJumpToPage("P_UrlChecker_Results");
