<?PHP
#
#   FILE:  ConfirmAutofix.php (UrlChecker plugin)
#
#   Part of the Metavus digital collections platform
#   Copyright 2011-2020 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#

use Metavus\MetadataField;
use Metavus\MetadataSchema;
use Metavus\Plugins\UrlChecker\Record;
use ScoutLib\StdLib;

# ----- MAIN -----------------------------------------------------------------

PageTitle("Confirm an automatic fix to the URL");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$MyPlugin = $GLOBALS["G_PluginManager"]->getPluginForCurrentPage();

$H_Id = StdLib::getFormValue("Id");
$UrlInfo = $MyPlugin->decodeUrlIdentifier($H_Id);

$ResourceId = $UrlInfo["RecordId"];
$FieldId = $UrlInfo["FieldId"];

if (Record::itemExists($ResourceId) &&
    MetadataSchema::fieldExistsInAnySchema($FieldId)) {
    $H_Field = new MetadataField($FieldId);
    $H_Resource = new Record($ResourceId);
    $H_InvalidUrl = $MyPlugin->getInvalidUrl(
        $ResourceId,
        $FieldId,
        $UrlInfo["UrlHash"]
    );
} else {
    $GLOBALS["AF"]->suppressHTMLOutput();
    $GLOBALS["AF"]->setJumpToPage("index.php?P=P_UrlChecker_Results");
}
