<?PHP
#
#   FILE:  Subscribe.php (Blog plugin)
#
#   Part of the Metavus digital collections platform
#   Copyright 2013-2020 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#

use Metavus\User;

# ----- MAIN -----------------------------------------------------------------

PageTitle("Subscribe to Blog Entry Notifications");

# retrieve user currently logged in
$User = User::getCurrentUser();

# get the blog plugin
$Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$Blog->SetCurrentBlog($Blog->ConfigSetting("EmailNotificationBlog"));

# if user is logged in
if ($User->IsLoggedIn()) {
    # change the subscription for the user
    $Blog->ChangeNotificationSubscription($User, true);

    # go back to the blog landing page
    $GLOBALS["AF"]->SetJumpToPage($Blog->BlogUrl());
} else {
    # send user to login page with appropriate prompt
    $_SESSION["LoginPrompt"] = $Blog->ConfigSetting("NotificationLoginPrompt");
    $GLOBALS["AF"]->SetJumpToPage("Login");
}
