<?PHP
#
#   FILE:  NotifySubscribers.php (Blog plugin)
#
#   Part of the Metavus digital collections platform
#   Copyright 2013-2020 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#

use Metavus\Plugins\Blog\Entry;
use Metavus\User;
# ----- MAIN -----------------------------------------------------------------

use ScoutLib\StdLib;

PageTitle("Notify Blog Subscribers");

# get the blog plugin and entry
$Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$Entry = new Entry(StdLib::getArrayValue($_GET, "ID"));

# don't allow unauthorized access
if (!$Entry->UserCanEdit(User::getCurrentUser())) {
    CheckAuthorization(false);
    return;
}

# don't notify if the entry is not from the Email Blog
$EntryBlogId = $Entry->GetBlogId();
if ($Blog->ConfigSetting("EmailNotificationBlog") != $EntryBlogId) {
    $GLOBALS["AF"]->SetJumpToPage("index.php?P=P_Blog_Entry&EntryId="
            . $Entry->Id()."&Error=ERROR_NOT_EMAIL_BLOG");
    return;
}

# notify subscribers
$Blog->NotifySubscribers($Entry);

# go back to the page for the blog entry
$GLOBALS["AF"]->SetJumpToPage($Entry->EntryUrl());
