<?PHP
#
#   FILE:  ControlledNameFactory_Test.php
#
#   Part of the Metavus digital collections platform
#   Copyright 2022 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu
#
# @scout:phpstan
// phpcs:disable PSR1.Classes.ClassDeclaration.MultipleClasses

namespace Metavus;

class ControlledNameFactory_Test extends \PHPUnit\Framework\TestCase
{
    protected static $TestFieldIds;
    protected static $TestFields;
    protected static $TestName;

    public static function setUpBeforeClass() : void
    {
        # construct the schema object
        $Schema = new MetadataSchema(MetadataSchema::SCHEMAID_DEFAULT);

        self::$TestFieldIds = [];

        # outline fields to be created
        self::$TestFields = ["ControlledNameTestField" => MetadataSchema::MDFTYPE_CONTROLLEDNAME];

        # create the fields
        foreach (self::$TestFields as $FieldName => $FieldType) {
            $TmpField = $Schema->GetItemByName($FieldName);
            if ($TmpField === null) {
                $TmpField = $Schema->AddField($FieldName, $FieldType);
            }
            $TmpField->IsTempItem(false);
            self::$TestFieldIds[$FieldName] = $TmpField->Id();
        }
    }

    public static function tearDownAfterClass() : void
    {
        # construct the schema object
        $Schema = new MetadataSchema(MetadataSchema::SCHEMAID_DEFAULT);

        # drop all of the test fields
        foreach (self::$TestFieldIds as $FieldId) {
            $Schema->DropField($FieldId);
        }

        if (self::$TestName !== null) {
            self::$TestName->destroy(true);
        }
    }

    public function testControlledNameFactory()
    {
        $MyId = self::$TestFieldIds['ControlledNameTestField'];

        $Factory = new ControlledNameFactory($MyId);

        $this->assertEquals(
            0,
            $Factory->GetUsageCount(),
            "Zero usage for newly created CName field"
        );

        $this->assertEquals(
            [],
            $Factory->ControlledNameSearch("*"),
            "No results from empty field"
        );

        self::$TestName = ControlledName::Create(
            "TestName",
            $MyId
        );

        $Expected = [ (string)self::$TestName->Id() ];

        $this->assertEquals(
            $Expected,
            $Factory->ControlledNameSearch("*"),
            "Correct results for wildcard search"
        );

        $this->assertEquals(
            $Expected,
            $Factory->ControlledNameSearch("*"),
            "Correct results for exact search"
        );

        $this->assertEquals(
            [],
            $Factory->FindMatchingRecentlyUsedValues(""),
            "No recently used values for empty string"
        );

        $this->assertEquals(
            [],
            $Factory->FindMatchingRecentlyUsedValues("TestName"),
            "No recently used values for exact search"
        );

        $this->assertEquals(
            [],
            $Factory->FindMatchingRecentlyUsedValues(
                "TestName",
                5,
                [self::$TestName->Id()],
                [self::$TestName->Name()]
            ),
            "No recently used values for exact search with value and id exclusions"
        );
    }
}
