<?PHP
#
#   FILE:  SystemConfiguration.php
#
#   Part of the Metavus digital collections platform
#   Copyright 2020-2021 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

namespace Metavus;

use ScoutLib\ApplicationFramework;

/**
 * System configuration setting storage and retrieval class.
 */
class SystemConfiguration extends \ScoutLib\SystemConfiguration
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    public function __construct()
    {
        static::dbTableName("SystemConfiguration");
        static::fields(static::$OurFieldDefinitions);
        parent::__construct();
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    protected static $OurFieldDefinitions = [
        "ActivateAccountTemplateId" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => null,
            "Description" => "ID of email template to use for activating new accounts.",
        ],
        "AddAWStatsScript" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether to enable AWStats web analytics support"
                    ." in site HTML.  (OBSOLETE?)",
        ],
        "AdminEmail" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Primary administrative email address.",
        ],
        "AllowMultipleUIsEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether regular users are allowed to select their user interface.",
        ],
        "AnnouncementsEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether to display blog entries on the home page.",
        ],
        "BrowsingFieldId" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 27,
            "Description" => "ID of metadata field to be used as default"
                    ." field for browsing interface.",
        ],
        "CollapseMetadataFieldGroups" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether to collapse metadata field groups by default.",
        ],
        "CommentsAllowHTML" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether HTML is allowed in resource comments.",
        ],
        "ContactEmail" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Email of administrative contact for site.",
        ],
        "ContactName" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Name of administrative contact for site.",
        ],
        "CurrentTheme" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "default",
            "Description" => "Currently-active user interface.  (OBSOLETE?)",
        ],
        "DefaultActiveUI" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "default",
            "Description" => "Default user interface.",
        ],
        "DefaultCharacterSet" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "UTF-8",
            "Description" => "Default character set for site.",
        ],
        "DefaultRecordsPerPage" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 20,
            "Description" => "Default number of records per page in search results.",
        ],
        "DefaultSortField" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => null,
            "Description" => "Default field to use for sorting search results.",
        ],
        "DefaultUserPrivs" => [
            "Type" => SystemConfiguration::TYPE_ARRAY,
            "Default" => [],
            "Description" => "Default user privileges.",
        ],
        "DisplayLimitsByDefault" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether to display limit parameters on Advanced"
                    ." Search page by default.",
        ],
        "EmailChangeTemplateId" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => null,
            "Description" => "ID of email template to use for email address"
                    ." changes.",
        ],
        "EmailDeliverySettings" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => null,
            "Description" => "Settings for email delivery.  (Opaque string"
                    ." from Email class.)",
        ],
        "EmailLineEnding" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "CRLF",
            "Description" => "What to use for line endings in emails."
                    ." (\"CRLF\", \"CR\", or \"LF\".)",
        ],
        "IncrementalKeywordSearchEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether incremental search should be enabled"
                    ." in the quick search box.",
        ],
        "LastRegisteredOn" => [
            "Type" => SystemConfiguration::TYPE_DATETIME,
            "Default" => null,
            "Description" => "When site was last registered with software"
                    ." platform developers.",
        ],
        "LegalNotice" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Text for legal notice to display in footer"
                    ." of default interface.",
        ],
        "MaxFacetsPerField" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 75,
            "Description" => "Maximum number of facets allowable for a"
                    ." field to appear in search facets.",
        ],
        "NumAnnounceOnHomePage" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 2,
            "Description" => "Maximum number of blog entries to display"
                    ." on home page.",
        ],
        "NumClassesPerBrowsePage" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 80,
            "Description" => "Maximum number of classifications to display"
                    ." on a page in resource browsing interface.",
        ],
        "NumColumnsPerBrowsePage" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 2,
            "Description" => "Number of columns to display per page in"
                    ." resource browsing interface.",
        ],
        "NumResourcesForSearchFacets" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 5000,
            "Description" => "Number of resources to be considered when"
                    ." building search facets.",
        ],
        "NumResourcesOnHomePage" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 5,
            "Description" => "Maximum number of new resources to display"
                    ." on home page.",
        ],
        "OkayToListSite" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether it is okay to include side in list of"
                    ." sites running similar software.",
        ],
        "Organization" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Organization that operates site.",
        ],
        "OrganizationType" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => null,
            "Description" => "Type of organization that operates site.",
        ],
        "PasswordChangeTemplateId" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => null,
            "Description" => "ID of email template to use for password changes.",
        ],
        "PasswordMinLength" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 6,
            "Description" => "Minimum required length for passwords.",
        ],
        "PasswordRequiresDigits" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether passwords must include numbers.",
        ],
        "PasswordRequiresMixedCase" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether passwords must include mixed case letters.",
        ],
        "PasswordRequiresPunctuation" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether passwords must include punctuation characters.",
        ],
        "PasswordUniqueChars" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => 4,
            "Description" => "Minimum number of unique characters in passwords.",
        ],
        "PortalName" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Name of site.",
        ],
        "PreferHttpHost" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "If available, prefer <i>\$_SERVER[\"HTTP_HOST\"]</i>"
                        ." over <i>\$_SERVER[\"SERVER_NAME\"]</i> when"
                        ." determining the current URL.",
        ],
        "PreferredLinkValue" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "FILE",
            "Description" => "Whether to display file(s) or URL(s) for"
                    ." records with both values set for the corresponding"
                    ." standard fields.  (\"FILE\" or \"URL\".)",
        ],
        "RecommenderDBEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether background updating of the recommender"
                    ." engine index is enabled.",
        ],
        "RecommenderEngineUpdatePriority" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => ApplicationFramework::PRIORITY_BACKGROUND,
            "Description" => "Task execution priority for recommender engine"
                    ." index updates.",
        ],
        "RequireEmailWithFeedback" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether to require an email address when user"
                    ." submits feedback via a feedback form.",
        ],
        "ResourceLaunchesNewWindowEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether clicking on a resource should open a"
                    ." new window.",
        ],
        "ResourceRatingsEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether resource ratings should be displayed"
                    ." and users should be allowed to rate resources.",
        ],
        "RootUrlOverride" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "String to use in place of the \"Root URL\""
                    ." (the portion of the URL up to and including the"
                    ." host name).",
        ],
        "SearchDBEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether background updating of the search"
                    ." engine index is enabled.",
        ],
        "SearchEngineUpdatePriority" => [
            "Type" => SystemConfiguration::TYPE_INT,
            "Default" => ApplicationFramework::PRIORITY_LOW,
            "Description" => "Task execution priority for search engine"
                    ." index updates.",
        ],
        "SearchTermsRequired" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => true,
            "Description" => "Whether all terms are required for searches"
                    ." (i.e. whether it is an AND search).",
        ],
        "ShowGroupNamesEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether group names are shown on the full"
                    ." record page.",
        ],
        "ShowNumResourcesEnabled" => [
            "Type" => SystemConfiguration::TYPE_BOOL,
            "Default" => false,
            "Description" => "Whether to display the current total number"
                    ." of viewable resources on the home page.",
        ],
        "SiteKeywords" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Keywords to be added to the \"keywords\" meta"
                    ." tag on all pages, for use by web search engines.",
        ],
        "SiteType" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => null,
            "Description" => "Type of site.",
        ],
        "TitlesLinkTo" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "URL",
            "Description" => "Whether to link record standard title field"
                    ." values to the standard URL field value or to the full"
                    ." record page.  (\"URL\" or \"RECORD\".)",
        ],
        "TopLinkBeginLetter" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => null,
            "Description" => "Top link first letter, used by BrowseResources"
                    ." to print classification links.",
        ],
        "TopLinkEndLetter" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => null,
            "Description" => "Top link last letter, used by BrowseResources"
                    ." to print classification links.",
        ],
        "TopLinkString" => [
            "Type" => SystemConfiguration::TYPE_STRING,
            "Default" => "",
            "Description" => "Top link string, used by BrowseResources to"
                    ." print classification links.",
        ],
    ];
}
