<?PHP
#
#   FILE:  MySearchesUI.php
#
#   Part of the Metavus digital collections platform
#   Copyright 2019-2021 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

namespace Metavus\Plugins\MySearches;

class MySearchesUI
{
    /**
     * Get HTML for saved search list block -- called by MySearches plugin
     * @param array $Searches array of search arrays to display; Each search
     *      array contains a string SearchURL which is the URL to reach the
     *      search, a string SearchTitle for use in the title field of the a
     *      tag linking to the seach and a SearchName for use in the a tag for
     *      linking to the search.
     * @return string Generated HTML.
     */
    public static function getHtmlForSavedSearchesBlock(array $Searches): string
    {
        $EditSearchesLink = $GLOBALS["AF"]->baseUrl()
            ."index.php?P=ListSavedSearches";
        $PencilImgPath = $GLOBALS["AF"]->baseUrl()
            .$GLOBALS["AF"]->gUIFile("Pencil.svg");

        ob_start();
        ?><!-- BEGIN SAVED SEARCHES BLOCK -->
        <div class="mv-section mv-section-simple mv-html5-section cw-mysearches-sidebar-saved">
            <div class="mv-section-header mv-html5-header">
                <a class="btn btn-primary btn-sm mv-button-iconed float-right"
                    href="<?= $EditSearchesLink ?>"><img class="mv-button-icon"
                    src="<?= $PencilImgPath ?>" alt=""> Edit</a>
                <img src="<?= $GLOBALS["AF"]->gUIFile("MagnifyingGlass.svg") ?>" alt="">
                My Searches
            </div>
            <div class="mv-section-body">
                <ul class="mv-bullet-list">
                <?PHP foreach ($Searches as $Search) { ?>
                    <li><a href="<?= $Search["SearchURL"];  ?>" title="Search Parameters:
                    <?= "\n".htmlspecialchars($Search["SearchTitle"]); ?>">
                    <?= $Search["SearchName"]; ?></a>
                    </li>
                <?PHP } ?>
                </ul>
            </div>
        </div>
        <!-- END SAVED SEARCHES BLOCK --><?PHP
        return (string)ob_get_clean();
    }

    /**
     * Get HTML for recent search list block -- called by MySearches plugin
     * @param array $Searches array of search arrays to display; Each search
     *      array contains a string SearchURL which is the URL to reach the
     *      search and a SearchName for use in the a tag for linking to the search.
     * @return string Generated HTML.
     */
    public static function getHtmlForRecentSearchesBlock($Searches): string
    {
        ob_start();
        ?><!-- BEGIN RECENT SEARCHES DISPLAY -->
        <div class="mv-section mv-section-simple mv-html5-section cw-mysearches-sidebar-recent">
            <div class="mv-section-header mv-html5-header">
                <img src="<?= $GLOBALS["AF"]->gUIFile("MagnifyingGlass.svg") ?>" alt="">
                Recent Searches
            </div>
            <div class="mv-section-body">
                <ul class="mv-bullet-list">
                <?PHP  foreach ($Searches as $Search) {  ?>
                    <li><a href="<?= $Search["SearchURL"] ?>">
                            <?= $Search["SearchName"] ?></a></li>
                <?PHP  }  ?>
                </ul>
            </div>
        </div>
        <!-- END RECENT SEARCHES DISPLAY --><?PHP
        return (string)ob_get_clean();
    }
}
