<?PHP
#
#   FILE:  ConfirmNotifySubscribers.php (Blog plugin)
#
#   Part of the Metavus digital collections platform
#   Copyright 2013-2020 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#

use Metavus\Plugins\Blog\Entry;
use Metavus\User;
# ----- MAIN -----------------------------------------------------------------

use ScoutLib\StdLib;

PageTitle("Notify Blog Subscribers Confirmation");

# get the blog plugin and entry
$H_Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$H_Entry = new Entry(StdLib::getArrayValue($_GET, "ID"));

# don't allow unauthorized access
if (!$H_Entry->UserCanEdit(User::getCurrentUser())) {
    CheckAuthorization(false);
    return;
}

# don't allow notification if the entry is not from the "email blog"
if ($H_Entry->GetBlogId() != $H_Blog->ConfigSetting("EmailNotificationBlog")) {
    $GLOBALS["AF"]->SetJumpToPage(
        "index.php?P=P_Blog_Entry&EntryId=".$H_Entry->Id()
        . "&Error=ERROR_NOT_EMAIL_BLOG"
    );
    return;
}
